//#define GameID "{877D4608-029D-44D7-90AC-8C6C1D2323CD}"
#define GameName "Borderlands"
#define GameVerName "Borderlands [v 1.0]"

[Setup]
AppName=My Program
AppVerName=My Program 1.5
AppPublisher=My Company, Inc.
AppPublisherURL=http://www.example.com/
AppSupportURL=http://www.example.com/
AppUpdatesURL=http://www.example.com/
DefaultDirName={pf}\My Program
DefaultGroupName=My Program
OutputBaseFilename=setup
Compression=lzma
SolidCompression=yes

[Languages]
Name: "rus"; MessagesFile: "compiler:Languages\Russian.isl"

[CustomMessages]
rus.Welcome=
rus.System=
rus.Catalogue=
rus.StartMenu= 
rus.Task=
rus.Installing=
rus.Uninstalling=
rus.Finish=

[CustomMessages]
rus.Welcome=
rus.System=
rus.Catalogue=
rus.StartMenu= 
rus.Task=
rus.Installing=
rus.Uninstalling=
rus.Finish=
rus.Welcome1=    %n{#GameName}
rus.Welcome2=   {#GameVerName}   .%n%n   ,       ,  .%n%n ,  ,   ,     .
rus.Requirements1=  
rus.Requirements2=     
rus.Requirements3=    .
rus.Requirements4=,  ,    .
rus.DeviceDriver=   
rus.Processor=
rus.VideoCard=
rus.SoundCard= 
rus.RAM= ()
rus.OperationSystem= 
rus.TotalSpace=  :
rus.FreeSpace=   :
rus.NeedSpace=   :
rus.SelectTasksLabel=  ,      ,    .
rus.Language=  :
rus.LanguageRus=
rus.LanguageUS=English
rus.StartMenuLbl= ,  .      ,  .
rus.TasksName=  
rus.TasksDescription=    ?
rus.DirectX= DirectX
rus.QuickLaunch=     
rus.Desktop=    
rus.DirectXInstall=  DirectX...
rus.AllProgress=  :
rus.Remains= 
rus.Hour=
rus.Min=
rus.Sec=
rus.FinishedHeading=  {#GameName}  .
rus.FinishedLabel= {#GameVerName}      .             .
rus.FinishedLabel2= ,     .
rus.Uninstall= {#GameName}
rus.DeleteSave=    ?
rus.WizardUninst= 
rus.UninstDescript=, ,       .
rus.StatusUninst=  {#GameName}...
rus.AllProgressUninst=   :

[Files]
;Source: "InstallFiles\*"; Flags: dontcopy;
Source: botva2.dll; Flags: dontcopy
Source: innocallback.dll; Flags: dontcopy
Source: StatusPanel.png; Flags: dontcopy
Source: StatusPanel2.png; Flags: dontcopy

[Icons]
Name: "{group}\My Program"; Filename: "{app}\MyProg.exe"

[code]
type
TBtnEventProc = procedure (h:HWND);

var
SystemPage, SelectTasksPage: TWizardPage;
WFButtonFont, UPFButtonFont: TFont;
Welcome, System, Catalogue, StartMenu, Tasks, Installing, Finish, Uninstalling: TLabel;
StatusPanel, RequirementsPanel, Edit,DirFolder,HardDrivePanel,
GroupFolder,WizardImg,OldPosition, HDD, PBOldProc: Longint;

function WrapBtnCallback(Callback: TBtnEventProc; ParamCount: Integer): Longword; external 'wrapcallback@{tmp}\innocallback.dll stdcall delayload';

function ImgLoad(Wnd :HWND; FileName :PAnsiChar; Left, Top, Width, Height :integer; Stretch, IsBkg :boolean) :Longint; external 'ImgLoad@{tmp}\botva2.dll stdcall delayload';
procedure ImgSetPosition(img :Longint; NewLeft, NewTop, NewWidth, NewHeight :integer); external 'ImgSetPosition@{tmp}\botva2.dll stdcall delayload';
procedure ImgRelease(img :Longint); external 'ImgRelease@{tmp}\botva2.dll stdcall delayload';
procedure ImgSetVisibility(img :Longint; Visible :boolean); external 'ImgSetVisibility@{tmp}\botva2.dll stdcall delayload';
function ImgGetVisibility(img:Longint):boolean; external 'ImgGetVisibility@{tmp}\botva2.dll stdcall delayload';
procedure ImgApplyChanges(h:HWND); external 'ImgApplyChanges@{tmp}\botva2.dll stdcall delayload';
procedure gdipShutdown;  external 'gdipShutdown@{tmp}\botva2.dll stdcall delayload';

function InitializeSetup: Boolean;
begin
  ExtractTemporaryFile('botva2.dll');
  ExtractTemporaryFile('innocallback.dll');
  Result:=True;
end;

//************************************************ [ -  ] ***************************************************//
procedure CreateWizardImage;
var
  i: integer;
begin
  WizardForm.ClientWidth:=ScaleX(798);
  WizardForm.ClientHeight:=ScaleY(543);
  WizardForm.Center;
  WizardForm.OuterNotebook.Hide;
  WizardForm.InnerNotebook.Hide;
  WizardForm.Bevel.Hide;

  WizardForm.CancelButton.Top:=ScaleY(503);
  WizardForm.CancelButton.Left:=ScaleX(684);
  WizardForm.NextButton.Top:=ScaleY(503);
  WizardForm.NextButton.Left:=ScaleX(604);
  WizardForm.BackButton.Top:=ScaleY(503);
  WizardForm.BackButton.Left:=ScaleX(524);

  ExtractTemporaryFile('StatusPanel.png');
  ExtractTemporaryFile('StatusPanel2.png');

  ImgLoad(WizardForm.Handle,ExpandConstant('{tmp}\StatusPanel.png'),ScaleX(0), ScaleY(95),WizardForm.ClientWidth,ScaleY(20),True,True);
  StatusPanel:=ImgLoad(WizardForm.Handle,ExpandConstant('{tmp}\StatusPanel2.png'),ScaleX(0), ScaleY(95),ScaleX(114),ScaleY(20),True,True);

ImgApplyChanges(WizardForm.Handle);
end;

//************************************************ [ -  ] ***************************************************//

//************************************************ [ - ] ***************************************************//
procedure CreateStatusPanel;
begin
  Welcome := TLabel.Create(WizardForm);
  with Welcome do begin
    AutoSize:=False;
    SetBounds(ScaleX(13), ScaleY(96), ScaleX(114), ScaleY(20));
    Transparent:=True;
    Font.Name:= 'Arial';
    Font.Size:= 10;
    Font.Style:=[fsBold];
    Caption := ExpandConstant('{cm:Welcome}');
    Parent := WizardForm;
  end;

  System := TLabel.Create(WizardForm);
  with System do begin
    AutoSize:=False;
    SetBounds(ScaleX(143), ScaleY(96), ScaleX(114), ScaleY(20));
    Transparent:=True;
    Font.Name:= 'Arial';
    Font.Size:= 10;
    Font.Style:=[fsBold];
    Caption := ExpandConstant('{cm:System}');
    Parent := WizardForm;
  end;

  Catalogue := TLabel.Create(WizardForm);
  with Catalogue do begin
    AutoSize:=False;
    SetBounds(ScaleX(260), ScaleY(96), ScaleX(114), ScaleY(20));
    Transparent:=True;
    Font.Name:= 'Arial';
    Font.Size:= 10;
    Font.Style:=[fsBold];
    Caption := ExpandConstant('{cm:Catalogue}');
    Parent := WizardForm;
  end;

  StartMenu := TLabel.Create(WizardForm);
  with StartMenu do begin
    AutoSize:=False;
    SetBounds(ScaleX(357), ScaleY(96), ScaleX(114), ScaleY(20));
    Transparent:=True;
    Font.Name:= 'Arial';
    Font.Size:= 10;
    Font.Style:=[fsBold];
    Caption := ExpandConstant('{cm:StartMenu}');
    Parent := WizardForm;
  end;

  Tasks := TLabel.Create(WizardForm);
  with Tasks do begin
    AutoSize:=False;
    SetBounds(ScaleX(490), ScaleY(96), ScaleX(114), ScaleY(20));
    Transparent:=True;
    Font.Name:= 'Arial';
    Font.Size:= 10;
    Font.Style:=[fsBold];
    Caption := ExpandConstant('{cm:Task}');
    Parent := WizardForm;
  end;

  Installing := TLabel.Create(WizardForm);
  with Installing do begin
    AutoSize:=False;
    SetBounds(ScaleX(593), ScaleY(96), ScaleX(114), ScaleY(20));
    Transparent:=True;
    Font.Name:= 'Arial';
    Font.Size:= 10;
    Font.Style:=[fsBold];
    Caption := ExpandConstant('{cm:Installing}');
    Parent := WizardForm;
  end;

  Finish := TLabel.Create(WizardForm);
  with Finish do begin
    AutoSize:=False;
    SetBounds(ScaleX(703), ScaleY(96), ScaleX(114), ScaleY(20));
    Transparent:=True;
    Font.Name:= 'Arial';
    Font.Size:= 10;
    Font.Style:=[fsBold];
    Caption := ExpandConstant('{cm:Finish}');
    Parent := WizardForm;
  end;
end;
//************************************************ [ - ] ***************************************************//

procedure CreatePageComponents;
var
  Pdm: string;
  vr,VidRam : Longint;
  Version: TWindowsVersion;
begin
SystemPage:=CreateCustomPage(wpLicense, ExpandConstant('{cm:Requirements1}'), ExpandConstant('{cm:Requirements2}'));
SelectTasksPage := CreateCustomPage(wpSelectProgramGroup, ExpandConstant('{cm:TasksName}'), ExpandConstant('{cm:TasksDescription}'));
end;

procedure ShowComponents(CurPageID: Integer);
begin
case CurPageID of
    wpWelcome:
    begin
    Welcome.Font.Color := $00FFFF;
    ImgSetPosition(StatusPanel,ScaleX(0),ScaleY(95),ScaleX(114),ScaleY(20));
end;

    SystemPage.ID:
    begin
      System.Font.Color := $00FFFF;
      ImgSetPosition(StatusPanel,ScaleX(114),ScaleY(95),ScaleX(114),ScaleY(20));
end;

wpSelectDir:
    begin
      Catalogue.Font.Color := $00FFFF;
      ImgSetPosition(StatusPanel,ScaleX(228),ScaleY(95),ScaleX(114),ScaleY(20));
end;
    wpSelectProgramGroup:
    begin
      StartMenu.Font.Color := $00FFFF;
      ImgSetPosition(StatusPanel,ScaleX(342),ScaleY(95),ScaleX(114),ScaleY(20));
end;
    SelectTasksPage.ID:
  begin
    Tasks.Font.Color := $00FFFF;
    ImgSetPosition(StatusPanel,ScaleX(456),ScaleY(95),ScaleX(114),ScaleY(20));
end;

    wpInstalling:
    begin
      Installing.Font.Color := $00FFFF;
      ImgSetPosition(StatusPanel,ScaleX(570),ScaleY(95),ScaleX(114),ScaleY(20));
end;

    wpFinished:
    begin
      Finish.Font.Color := $00FFFF;
      ImgSetPosition(StatusPanel,ScaleX(684),ScaleY(95),ScaleX(114),ScaleY(20));
    end
  end;
end;


//************************************************ [ -  ] ***************************************************//
procedure InitializeWizard;
begin
  CreateStatusPanel;
CreateWizardImage;
CreatePageComponents;
end;

procedure CurPageChanged(CurPageID: Integer);
begin
  Welcome.Font.Color := $FFFFFF;
  System.Font.Color := $FFFFFF;
  Catalogue.Font.Color := $FFFFFF;
  StartMenu.Font.Color := $FFFFFF;
  Tasks.Font.Color := $FFFFFF;
  Installing.Font.Color :=$FFFFFF;
  Finish.Font.Color := $FFFFFF;

  ShowComponents(CurPageID);
  ImgApplyChanges(WizardForm.Handle);
end;

procedure DeinitializeSetup;
begin
  gdipShutdown;
end;

